/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.util;

public class BitSet {
    private int[] bit_bags;
    private boolean has_bits;

    public BitSet(int capacity_in_bits) {
        this.bit_bags = new int[capacity_in_bits + 31 >> 5];
    }

    public BitSet() {
        this(256);
    }

    public boolean add(int i) {
        boolean bit_not_set;
        int bag_index = i >> 5;
        this.ensureIndexWithinRange(bag_index);
        int bit_index = i & 0x1F;
        int bit_mask = 1 << bit_index;
        boolean bl = bit_not_set = (this.bit_bags[bag_index] & bit_mask) == 0;
        if (bit_not_set) {
            int n = bag_index;
            this.bit_bags[n] = this.bit_bags[n] | bit_mask;
            this.has_bits = true;
        }
        return bit_not_set;
    }

    public boolean add(BitSet another_set) {
        boolean new_bits_added = false;
        if (another_set.has_bits) {
            int cmp_len = another_set.bit_bags.length;
            if (cmp_len > this.bit_bags.length) {
                this.expandCapacity(cmp_len);
            }
            int i = 0;
            while (i < cmp_len) {
                int diff = another_set.bit_bags[i] & ~this.bit_bags[i];
                if (diff != 0) {
                    int n = i;
                    this.bit_bags[n] = this.bit_bags[n] | diff;
                    new_bits_added = true;
                    this.has_bits = true;
                }
                ++i;
            }
        }
        return new_bits_added;
    }

    public boolean isSet(int i) {
        return this.has_bits && (this.bit_bags[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    public boolean isEmpty() {
        return !this.has_bits;
    }

    public void forEachElementRun(Processor proc) {
        if (this.has_bits) {
            int bag_index = 0;
            while (bag_index < this.bit_bags.length) {
                int bit_index = bag_index << 5;
                int bag = this.bit_bags[bag_index];
                while (bag != 0) {
                    if ((bag & 1) == 0) {
                        if ((bag & 0xFFFF) == 0) {
                            bit_index += 16;
                            bag >>>= 16;
                        }
                        if ((bag & 0xFF) == 0) {
                            bit_index += 8;
                            bag >>>= 8;
                        }
                        if ((bag & 0xF) == 0) {
                            bit_index += 4;
                            bag >>>= 4;
                        }
                        if ((bag & 3) == 0) {
                            bit_index += 2;
                            bag >>>= 2;
                        }
                        if ((bag & 1) == 0) {
                            ++bit_index;
                            bag >>>= 1;
                        }
                    }
                    proc.process(bit_index);
                    bag >>>= 1;
                    ++bit_index;
                }
                ++bag_index;
            }
        }
    }

    private void ensureIndexWithinRange(int bag_index) {
        if (bag_index >= this.bit_bags.length) {
            if (bag_index > 65535) {
                throw new IllegalArgumentException("huge bit sets (more than 2M bits) are not supported");
            }
            int new_length = bag_index | bag_index >> 1;
            new_length |= new_length >> 2;
            new_length |= new_length >> 4;
            new_length |= new_length >> 8;
            this.expandCapacity(new_length + 1);
        }
    }

    private void expandCapacity(int new_length) {
        int[] new_bags = new int[new_length];
        System.arraycopy(this.bit_bags, 0, new_bags, 0, this.bit_bags.length);
        this.bit_bags = new_bags;
    }

    public static abstract class Processor {
        protected abstract void process(int var1);
    }
}

